import flixel.addons.effects.FlxTrail;
import funkin.backend.MusicBeatState;
MusicBeatState.skipTransIn = MusicBeatState.skipTransOut = true;
var devMode = false;
var bloom = new CustomShader("Bloom");
var bloomaMount = 1;

var ghost1:FlxTrail;
var ghost2:FlxTrail;
var ghostOffset:Float = 400;

var watermark = new FlxSprite(40, 620);
watermark.loadGraphic("images/stages/yee/opla.png");
watermark.flipX = true;
watermark.scale.set(0.4, 0.4);
watermark.updateHitbox();
watermark.antialiasing = true;
watermark.alpha = 0.5;


function postCreate()
{
	strumLines.members[1].characters[0].x += ghostOffset;
	strumLines.members[1].characters[1].x -= ghostOffset;
	for (i in [strumLines.members[1].characters[0], strumLines.members[1].characters[1]]) {
		//i.y -= 20;
		i.blend = 0;
		i.shader = bloom;
		i.alpha = 0.001;
		i.scale.set(0.7, 0.7);

	}
	ghost1 = new FlxTrail(strumLines.members[1].characters[0], null, 4, 4, 0.15, 0.1);
	ghost2 = new FlxTrail(strumLines.members[1].characters[1], null, 4, 4, 0.15, 0.1);
	PlayState.instance.insert(PlayState.instance.members.indexOf(strumLines.members[1].characters[0]), ghost1);
	PlayState.instance.insert(PlayState.instance.members.indexOf(strumLines.members[1].characters[0]), ghost2);
	for (i in [ghost1, ghost2]) {
		i.blend = 0;
		//i.shader = bloom;
		i.alpha = 0;
	}
	camGame.followLerp = 99;
	GameOverSubstate.script = 'data/scripts/gameovers/important';
	
	if (!devMode) {
	camGame.visible = false;
	camHUD.alpha = 0.001;
	}

	camGame.addShader(bloom);
	camHUD.addShader(bloom);
	bloom.data.Size.value = [10, 10];
	strumLines.members[0].characters[0].visible = false;

	watermark.cameras = [camHUD2];
	add(watermark);
	cpuStrums.forEach(function(e)
		{
			FlxTween.cancelTweensOf(e);
			e.alpha = 1;
		});
	for (i in cpuStrums.members) i.alpha = 0.001;
}

function onCountdown(event:CountdownEvent)
{
	event.cancel();
	camGame.followLerp = 0.04;
}

function bloomHit() bloomaMount = 0.6;

function hiGhosts() {
	for (e in [strumLines.members[1].characters[0], strumLines.members[1].characters[1]]) {
	    FlxTween.tween(e, {alpha: 0.3},  0.1);
	}
	for (i in [ghost1, ghost2]) {
		FlxTween.tween(i, {alpha: 0.1},  0.1);
	}
}
function byeGhosts() {
	for (e in [strumLines.members[1].characters[0], strumLines.members[1].characters[1]]) {
	    FlxTween.tween(e, {alpha: 0.001},  0.4);
	}
	for (i in [ghost1, ghost2]) {
		FlxTween.tween(i, {alpha: 0},  0.4);
	}
}

function stepHit (step) {
	switch (step) {
	    case 1:
		    if (!devMode) camGame.fade(FlxColor.BLACK, 5, true);
			for (i in cpuStrums.members) i.alpha = 0.001;
		    camGame.visible = true;
		case 56: if (!devMode) FlxTween.tween(camHUD, {alpha: 1}, 0.3, {ease: FlxEase.quadOut});
		case 2080:
			for (i in playerStrums.members) FlxTween.tween(i, {x: i.x + 240}, 2, {ease: FlxEase.quadInOut});
			for (i in cpuStrums.members) FlxTween.tween(i, {alpha: 1}, 0.6, {startDelay: 1.4, ease: FlxEase.sineInOut});
		case 2112:
			//camHUD.visible = false;
			camGame.removeShader(bloom);
		    strumLines.members[0].characters[0].visible = true;
			camGame.followLerp = 0;
			strumLines.members[1].characters[2].visible = false;
			camGame.focusOn(FlxPoint.weak(240, 400));
			defaultCamZoom = 0.8;
			FlxG.camera.zoom = defaultCamZoom;
		case 2121:
			strumLines.members[0].characters[0].visible = false;
			camGame.focusOn(FlxPoint.weak(240, 620));
			strumLines.members[1].characters[2].visible = true;
			defaultCamZoom = 0.6;
			FlxG.camera.zoom = defaultCamZoom;
	}
}
function update(elapsed:Float) { 
	bloomaMount = FlxMath.lerp(bloomaMount, 1, elapsed*2);
    bloom.data.dim.value = [bloomaMount, bloomaMount];
}